/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data.impl;

import ca.lukegrahamlandry.lib.data.DataWrapper;
import ca.lukegrahamlandry.lib.data.sync.GlobalDataSyncMessage;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.class_5218;

public class GlobalDataWrapper<T>
extends DataWrapper<T>
implements Supplier<T> {
    T value;

    public GlobalDataWrapper(Class<T> clazz) {
        super(clazz);
    }

    @Override
    public T get() {
        if (!this.isLoaded) {
            this.logger.error("cannot call DataWrapper#get (a) before server startup (b) on client if unsynced");
            return null;
        }
        return this.value;
    }

    public void clear() {
        this.value = this.createDefaultInstance();
        this.setDirty();
    }

    @Override
    public void load() {
        if (server == null) {
            String msg = "cannot call DataWrapper#load (a) before server startup (b) on client";
            this.logger.error(msg);
            throw new RuntimeException(msg);
        }
        if (!this.getFilePath().toFile().exists()) {
            this.isLoaded = true;
            return;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(this.getFilePath());
            this.value = this.getGson().fromJson((Reader)reader, this.clazz);
            ((Reader)reader).close();
        }
        catch (JsonSyntaxException | IOException e) {
            String msg = "failed to load data from " + GlobalDataWrapper.forDisplay(this.getFilePath());
            this.logger.error(msg);
            e.printStackTrace();
        }
        this.isLoaded = true;
    }

    @Override
    public void save() {
        Path path = this.getFilePath();
        path.toFile().getParentFile().mkdirs();
        Gson pretty = this.getGson().newBuilder().setPrettyPrinting().create();
        String json = pretty.toJson(this.value);
        try {
            Files.write(path, json.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            this.logger.error("failed to write data to " + GlobalDataWrapper.forDisplay(path));
        }
    }

    @Override
    public void sync() {
        if (!this.shouldSync) {
            this.logger.error("called DataWrapper#sync but shouldSync=false");
            return;
        }
        new GlobalDataSyncMessage(this).sendToAllClients();
    }

    protected Path getFilePath() {
        Path path = server.method_27050(class_5218.field_24188).resolve("data");
        if (this.getSubDirectory() != null) {
            path = path.resolve(this.getSubDirectory());
        }
        path = path.resolve(this.getName() + "." + this.fileExtension);
        return path;
    }

    public void set(Object v) {
        this.value = v;
    }
}

