/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.data;

import ca.lukegrahamlandry.lib.base.Available;
import ca.lukegrahamlandry.lib.base.json.JsonHelper;
import ca.lukegrahamlandry.lib.data.impl.GlobalDataWrapper;
import ca.lukegrahamlandry.lib.data.impl.LevelDataWrapper;
import ca.lukegrahamlandry.lib.data.impl.PlayerDataWrapper;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataWrapper<T> {
    public static List<DataWrapper<?>> ALL = new ArrayList();
    public static MinecraftServer server;
    public final Class<T> clazz;
    private String name;
    public String fileExtension = "json";
    protected String subDirectory = null;
    boolean shouldSave = false;
    protected boolean shouldSync = false;
    protected boolean isLoaded = false;
    protected boolean isDirty = false;
    public Logger logger;
    private Gson gson;
    public static final Logger LOGGER;

    public static <T> GlobalDataWrapper<T> global(Class<T> clazz) {
        return new GlobalDataWrapper<T>(clazz);
    }

    public static <T> LevelDataWrapper<T> level(Class<T> clazz) {
        return new LevelDataWrapper<T>(clazz);
    }

    public static <T> PlayerDataWrapper<T> player(Class<T> clazz) {
        return new PlayerDataWrapper<T>(clazz);
    }

    public <W extends DataWrapper<T>> W synced() {
        if (!Available.NETWORK.get()) {
            throw new RuntimeException("Called DataWrapper#synced but WrapperLib Network module is missing.");
        }
        this.shouldSync = true;
        return (W)this;
    }

    public <W extends DataWrapper<T>> W saved() {
        this.shouldSave = true;
        return (W)this;
    }

    public <W extends DataWrapper<T>> W named(class_2960 name) {
        this.dir(name.method_12836());
        this.named(name.method_12832());
        return (W)this;
    }

    public <W extends DataWrapper<T>> W named(String name) {
        this.name = JsonHelper.safeFileName(name);
        this.createLogger();
        return (W)this;
    }

    public <W extends DataWrapper<T>> W dir(String subDirectory) {
        this.subDirectory = JsonHelper.safeFileName(subDirectory);
        this.createLogger();
        return (W)this;
    }

    public <W extends DataWrapper<T>> W ext(String fileExtension) {
        this.fileExtension = fileExtension;
        return (W)this;
    }

    public <W extends DataWrapper<T>> W withGson(Gson gson) {
        this.gson = gson;
        return (W)this;
    }

    public void setDirty() {
        this.isDirty = true;
        if (this.shouldSync) {
            this.sync();
        }
    }

    public void init() {
    }

    protected DataWrapper(Class<T> clazz) {
        this.clazz = clazz;
        this.named(DataWrapper.defaultName(clazz));
        this.withGson(JsonHelper.get());
        this.createDefaultInstance();
        ALL.add(this);
    }

    public abstract void save();

    public abstract void load();

    public abstract void sync();

    public String getName() {
        return this.name;
    }

    public String getSubDirectory() {
        return this.subDirectory;
    }

    public Gson getGson() {
        return this.gson;
    }

    private static String defaultName(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase(Locale.ROOT);
    }

    public T createDefaultInstance() {
        try {
            return this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error(this.clazz.getName() + " does not have a public parameterless constructor");
            throw new RuntimeException(this.clazz.getName() + " does not have a public parameterless constructor", e);
        }
    }

    protected void createLogger() {
        String id = DataWrapper.class.getName() + ": ";
        if (this.getSubDirectory() != null) {
            id = id + this.getSubDirectory() + "/";
        }
        id = id + this.getName();
        this.logger = LoggerFactory.getLogger((String)id);
    }

    public static String forDisplay(Path path) {
        try {
            return path.toAbsolutePath().toFile().getCanonicalPath();
        }
        catch (IOException e) {
            return path.toAbsolutePath().toString();
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(DataWrapper.class);
    }
}

