/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.lib.base.event;

import ca.lukegrahamlandry.lib.base.event.IEventCallbacks;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class EventWrapper {
    private static final List<IEventCallbacks> HANDLERS = new ArrayList<IEventCallbacks>();

    public static void add(IEventCallbacks handler) {
        HANDLERS.add(handler);
    }

    public static void add(String handlerClassName) {
        try {
            Class<?> clazz = Class.forName(handlerClassName);
            EventWrapper.add((IEventCallbacks)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException clazz) {
        }
        catch (ClassCastException e) {
            throw new RuntimeException(handlerClassName + " must implement IEventCallbacks", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(handlerClassName + " does not have a public parameterless constructor", e);
        }
    }

    public static List<IEventCallbacks> get() {
        return HANDLERS;
    }

    public static void init() {
        EventWrapper.get().forEach(IEventCallbacks::onInit);
    }

    static {
        EventWrapper.add("ca.lukegrahamlandry.lib.network.forge.NetworkWrapperImpl");
        EventWrapper.add("ca.lukegrahamlandry.lib.network.fabric.NetworkWrapperImpl");
        EventWrapper.add("ca.lukegrahamlandry.lib.network.HandshakeHelper");
        EventWrapper.add("ca.lukegrahamlandry.lib.config.EventCallbacks");
        EventWrapper.add("ca.lukegrahamlandry.lib.data.EventCallbacks");
    }
}

