/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.data.remote;

import ca.lukegrahamlandry.cosmetology.CosmetologyApi;
import ca.lukegrahamlandry.cosmetology.data.impl.AvailableCosmeticsImpl;
import ca.lukegrahamlandry.cosmetology.util.EncodeUtil;
import ca.lukegrahamlandry.cosmetology.util.UrlFetchUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;

public class RemoteAvailableCosmetics
extends AvailableCosmeticsImpl {
    private String id;
    private String url;

    public static RemoteAvailableCosmetics get(String url) {
        JsonElement data = UrlFetchUtil.getUrlJson(url);
        if (data == null) {
            return null;
        }
        try {
            RemoteAvailableCosmetics self = (RemoteAvailableCosmetics)EncodeUtil.GSON.fromJson(data, RemoteAvailableCosmetics.class);
            if (self.url == null) {
                self.url = url;
            }
            if (!self.url.equals(url)) {
                self.update();
            }
            return self;
        }
        catch (JsonSyntaxException e) {
            CosmetologyApi.errorLog("Failed to parse RemoteAvailableCosmetics from " + url);
            e.printStackTrace();
            return null;
        }
    }

    public RemoteAvailableCosmetics(String url) {
        this.url = url;
        this.update();
    }

    public void update() {
        RemoteAvailableCosmetics self = RemoteAvailableCosmetics.get(this.url);
        if (self != null) {
            this.cosmetics.clear();
            this.cosmetics.putAll(self.cosmetics);
            this.id = self.id;
            this.url = self.url;
        }
    }
}

