/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.data.packet.network.clientbound;

import ca.lukegrahamlandry.cosmetology.CosmetologyApi;
import ca.lukegrahamlandry.cosmetology.data.PlayerCosmeticsCollection;
import ca.lukegrahamlandry.cosmetology.data.api.DataStore;
import ca.lukegrahamlandry.cosmetology.data.packet.network.BaseMessage;
import java.util.Map;
import java.util.UUID;
import net.minecraft.util.ResourceLocation;

public class SyncPlayerCosmeticsMsg
extends BaseMessage {
    private String sourceID;
    private Map<UUID, PlayerCosmeticsCollection> cosmetics;

    public SyncPlayerCosmeticsMsg(String sourceID, Map<UUID, PlayerCosmeticsCollection> cosmetics) {
        this.sourceID = sourceID;
        this.cosmetics = cosmetics;
    }

    @Override
    public void handle() {
        DataStore store = CosmetologyApi.getSource(this.sourceID);
        for (UUID player : this.cosmetics.keySet()) {
            PlayerCosmeticsCollection data = this.cosmetics.get(player);
            store.lockAll(player);
            for (ResourceLocation resourceLocation : data.unlocked) {
                store.unlock(player, resourceLocation);
            }
            store.unfavouriteAll(player);
            for (ResourceLocation resourceLocation : data.favourites) {
                store.favourite(player, resourceLocation);
            }
            store.unequipAll(player);
            for (Map.Entry entry : data.equipped.entrySet()) {
                store.set(player, (ResourceLocation)entry.getKey(), (ResourceLocation)entry.getValue());
            }
        }
    }
}

