/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.data.packet;

import ca.lukegrahamlandry.cosmetology.CosmetologyApi;
import ca.lukegrahamlandry.cosmetology.data.PlayerCosmeticsCollection;
import ca.lukegrahamlandry.cosmetology.data.packet.ServerPacketDataStore;
import ca.lukegrahamlandry.cosmetology.data.packet.network.BaseMessage;
import ca.lukegrahamlandry.cosmetology.util.EncodeUtil;
import ca.lukegrahamlandry.cosmetology.util.UrlFetchUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;

public class ServerPacketDataStoreWeb
extends ServerPacketDataStore {
    protected String unlockedUrl;

    public ServerPacketDataStoreWeb(String id, BiConsumer<ServerPlayerEntity, BaseMessage> sendPacketToPlayer, String unlockedUrl) {
        super(id, sendPacketToPlayer);
        this.unlockedUrl = unlockedUrl;
    }

    @Override
    public void onPlayerLogin(PlayerEntity player) {
        UnlockedCosmetics data = UnlockedCosmetics.get(this.unlockedUrl);
        if (data != null) {
            PlayerCosmeticsCollection cosmetics = this.model.getOrCreateData(player.func_110124_au());
            if (data.unlocked.containsKey(player.func_110124_au())) {
                cosmetics.unlocked = data.unlocked.get(player.func_110124_au());
            } else {
                cosmetics.unlocked.clear();
            }
        }
        super.onPlayerLogin(player);
    }

    static class UnlockedCosmetics {
        HashMap<UUID, ArrayList<ResourceLocation>> unlocked = new HashMap();

        UnlockedCosmetics() {
        }

        public static UnlockedCosmetics get(String url) {
            try {
                JsonElement data = UrlFetchUtil.getUrlJson(url);
                if (data == null) {
                    return null;
                }
                CosmetologyApi.debugLog("Got json for UnlockedCosmetics from " + url + ": " + data);
                return (UnlockedCosmetics)EncodeUtil.GSON.fromJson(data, UnlockedCosmetics.class);
            }
            catch (JsonSyntaxException e) {
                CosmetologyApi.errorLog("Failed to parse UnlockedCosmetics from " + url);
                e.printStackTrace();
                return null;
            }
        }
    }
}

