/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.data.packet;

import ca.lukegrahamlandry.cosmetology.CosmetologyApi;
import ca.lukegrahamlandry.cosmetology.data.DataStoreImpl;
import ca.lukegrahamlandry.cosmetology.data.PlayerCosmeticsCollection;
import ca.lukegrahamlandry.cosmetology.data.packet.network.BaseMessage;
import ca.lukegrahamlandry.cosmetology.data.packet.network.clientbound.RegisterMsg;
import ca.lukegrahamlandry.cosmetology.data.packet.network.clientbound.SyncPlayerCosmeticsMsg;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.WorldSavedData;

public class ServerPacketDataStore {
    public BiConsumer<ServerPlayerEntity, BaseMessage> sendPacketToPlayer;
    public DataStoreImpl model;

    public ServerPacketDataStore(String id, BiConsumer<ServerPlayerEntity, BaseMessage> sendPacketToPlayer) {
        this.model = new DataStoreImpl(id);
        this.sendPacketToPlayer = sendPacketToPlayer;
    }

    public void onPlayerLogin(PlayerEntity player) {
        this.syncAllToPlayer((ServerPlayerEntity)player);
        this.syncPlayerToAll((ServerPlayerEntity)player);
        this.sendPacketToPlayer.accept((ServerPlayerEntity)player, new RegisterMsg(this.model.getStoreID(), this.model.getAll()));
    }

    public void syncPlayerToAll(ServerPlayerEntity player) {
        HashMap<UUID, PlayerCosmeticsCollection> map = new HashMap<UUID, PlayerCosmeticsCollection>();
        map.put(player.func_110124_au(), this.model.getOrCreateData(player.func_110124_au()));
        SyncPlayerCosmeticsMsg message = new SyncPlayerCosmeticsMsg(this.model.getStoreID(), map);
        for (ServerPlayerEntity other : player.field_70170_p.func_73046_m().func_184103_al().func_181057_v()) {
            this.sendPacketToPlayer.accept(other, message);
        }
        this.setStorageDirty(player.field_71133_b);
    }

    public void syncAllToPlayer(ServerPlayerEntity player) {
        HashMap<UUID, PlayerCosmeticsCollection> map = new HashMap<UUID, PlayerCosmeticsCollection>();
        for (ServerPlayerEntity other : player.field_70170_p.func_73046_m().func_184103_al().func_181057_v()) {
            map.put(other.func_110124_au(), this.model.getOrCreateData(other.func_110124_au()));
        }
        SyncPlayerCosmeticsMsg message = new SyncPlayerCosmeticsMsg(this.model.getStoreID(), map);
        this.sendPacketToPlayer.accept(player, message);
    }

    public DataStorage getStorage(MinecraftServer server) {
        return (DataStorage)server.func_241755_D_().func_217481_x().func_215752_a(() -> new DataStorage(), this.model.getStoreID());
    }

    public void setStorageDirty(MinecraftServer server) {
        this.getStorage(server).func_76185_a();
    }

    public class DataStorage
    extends WorldSavedData {
        public DataStorage() {
            super(ServerPacketDataStore.this.model.getStoreID());
        }

        public void func_76184_a(CompoundNBT tag) {
            ServerPacketDataStore.this.model.read(tag.func_74779_i("data"));
            CosmetologyApi.debugLog("load " + tag.func_74779_i("data"));
        }

        public CompoundNBT func_189551_b(CompoundNBT tag) {
            tag.func_74778_a("data", ServerPacketDataStore.this.model.write());
            CosmetologyApi.debugLog("save " + tag.func_74779_i("data"));
            return tag;
        }
    }
}

