/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.data.api;

import ca.lukegrahamlandry.cosmetology.CosmetologyApi;
import ca.lukegrahamlandry.cosmetology.util.EncodeUtil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class CosmeticInfo {
    public final ResourceLocation id;
    public final ResourceLocation slot;
    public final String clazz;

    public CosmeticInfo(ResourceLocation id, ResourceLocation slot) {
        this.id = id;
        this.slot = slot;
        this.clazz = this.getClass().getName();
    }

    public boolean isRegisterAllowed() {
        return true;
    }

    public void guiButtonRender(int centerX, int centerY, int width, int height, boolean glint, boolean selected) {
        CosmetologyApi.errorLog("Cannot render cosmetic button for: " + this);
    }

    public TextComponent getDisplayTitle() {
        return new TranslationTextComponent("cosmetic." + this.id.func_110624_b() + "." + this.id.func_110623_a());
    }

    public TextComponent getDisplayDescription() {
        return new TranslationTextComponent("cosmetic." + this.id.func_110624_b() + "." + this.id.func_110623_a() + ".desc");
    }

    public static class Serializer
    implements JsonDeserializer<CosmeticInfo>,
    JsonSerializer<CosmeticInfo> {
        public static Map<String, Class<? extends CosmeticInfo>> LEGACY_FIXERS = new HashMap<String, Class<? extends CosmeticInfo>>();

        public CosmeticInfo deserialize(JsonElement input, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            Class<Object> clazz;
            String className = input.getAsJsonObject().get("clazz").getAsString();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (LEGACY_FIXERS.containsKey(className)) {
                    clazz = LEGACY_FIXERS.get(className);
                }
                CosmetologyApi.errorLog("Cannot deserialize CosmeticInfo json: " + input);
                e.printStackTrace();
                return null;
            }
            return (CosmeticInfo)EncodeUtil.GSON.fromJson(input, clazz);
        }

        public JsonElement serialize(CosmeticInfo input, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            return EncodeUtil.GSON.toJsonTree((Object)input);
        }
    }
}

