/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class PlayerCosmeticsCollection {
    public Map<ResourceLocation, ResourceLocation> equipped = new HashMap<ResourceLocation, ResourceLocation>();
    public List<ResourceLocation> unlocked = new ArrayList<ResourceLocation>();
    public List<ResourceLocation> favourites = new ArrayList<ResourceLocation>();

    public void equip(ResourceLocation slot, ResourceLocation cosmetic) {
        if (cosmetic == null) {
            this.equipped.remove(slot);
        } else {
            this.equipped.put(slot, cosmetic);
        }
    }

    public boolean hasUnlocked(ResourceLocation cosmetic) {
        return this.unlocked.contains(cosmetic);
    }

    public void lock(ResourceLocation cosmetic) {
        this.unlocked.remove(cosmetic);
    }

    public void unlock(ResourceLocation cosmetic) {
        this.unlocked.add(cosmetic);
    }

    public boolean isFavourite(ResourceLocation cosmetic) {
        return this.favourites.contains(cosmetic);
    }

    public void unfavourite(ResourceLocation cosmetic) {
        this.favourites.remove(cosmetic);
    }

    public void favourite(ResourceLocation cosmetic) {
        this.favourites.add(cosmetic);
    }

    public ResourceLocation getFromSlot(ResourceLocation slotID) {
        return this.equipped.get(slotID);
    }

    public void lockAll() {
        this.unlocked.clear();
        this.equipped.clear();
    }

    public void unfavouriteAll() {
        this.favourites.clear();
    }
}

