/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.client.screen.widget;

import ca.lukegrahamlandry.cosmetology.client.screen.widget.Drawable;
import ca.lukegrahamlandry.cosmetology.client.screen.widget.btn.CosmeticButton;
import ca.lukegrahamlandry.cosmetology.data.DataStoreImpl;
import ca.lukegrahamlandry.cosmetology.data.api.CosmeticInfo;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.ResourceLocation;

public class CosmeticsScrollGrid
extends ExtendedList<Entry> {
    private final Consumer<Button> buttonAdder;
    public final int x;
    public final int y;
    private final int width;
    private final int height;
    private final DataStoreImpl backingDataStore;
    protected List<CosmeticInfo> cosmetics = new ArrayList<CosmeticInfo>();
    int buttonCount;
    protected List<Runnable> tooltips = new ArrayList<Runnable>();
    public Drawable hoveredTexture;
    public Drawable texture;
    public Drawable activeTexture;
    public Drawable favouriteStar;
    private final OnEquipCallback equipCallback;
    private final OnFavouriteCallback favouriteCallback;
    private Map<ResourceLocation, CosmeticButton> btns = new HashMap<ResourceLocation, CosmeticButton>();

    public CosmeticsScrollGrid(Consumer<Button> buttonAdder, int x, int y, int width, int height, DataStoreImpl backingDataStore, OnEquipCallback sendEquipPacket, OnFavouriteCallback sendFavouritePacket) {
        super(Minecraft.func_71410_x(), width, height, y, y + height, 49);
        this.field_230675_l_ = x;
        this.field_230674_k_ = this.field_230675_l_ + width;
        this.buttonAdder = buttonAdder;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.buttonCount = Math.floorDiv(width, 38);
        this.backingDataStore = backingDataStore;
        this.equipCallback = sendEquipPacket;
        this.favouriteCallback = sendFavouritePacket;
        this.func_244605_b(false);
        this.func_230944_a_(false, 0);
        this.func_230943_a_(false);
        this.func_244606_c(false);
    }

    public void setCosmetics(List<CosmeticInfo> sources) {
        if (Minecraft.func_71410_x().field_71462_r == null) {
            return;
        }
        this.cosmetics = new ArrayList<CosmeticInfo>();
        this.cosmetics.addAll(sources);
        this.btns.clear();
        Minecraft.func_71410_x().field_71462_r.func_231039_at__().removeIf(btn -> btn instanceof CosmeticButton);
        while (!this.func_231039_at__().isEmpty()) {
            this.func_230964_j_(0);
        }
        int xIndex = 0;
        int btnWidth = 39;
        int btnHeight = 49;
        ArrayList<CosmeticButton> toAdd = new ArrayList<CosmeticButton>();
        for (CosmeticInfo info : this.cosmetics) {
            CosmeticButton b = new CosmeticButton(info, this.x + xIndex * btnWidth, this.y, 39, 50, button -> this.setAsActive(info), button -> this.setAsFavourite(info), this.tooltips::add, this.texture, this.hoveredTexture, this.activeTexture, this.favouriteStar);
            b.buttonStateActive = this.backingDataStore.getActive(Minecraft.func_71410_x().field_71439_g.func_110124_au()).contains(info);
            b.field_230693_o_ = this.backingDataStore.hasUnlocked(Minecraft.func_71410_x().field_71439_g.func_110124_au(), info.id);
            b.buttonStateFavourite = this.backingDataStore.isFavourite(Minecraft.func_71410_x().field_71439_g.func_110124_au(), info.id);
            toAdd.add(b);
            this.btns.put(info.id, b);
            if (++xIndex < this.buttonCount) continue;
            xIndex = 0;
            this.func_230513_b_((AbstractList.AbstractListEntry)new Entry(new ArrayList<Widget>(toAdd)));
            toAdd.forEach(this.buttonAdder);
            toAdd.clear();
        }
        if (xIndex != 0) {
            Collections.reverse(toAdd);
            this.func_230513_b_((AbstractList.AbstractListEntry)new Entry(new ArrayList<Widget>(toAdd)));
            toAdd.forEach(this.buttonAdder);
        }
    }

    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        this.tooltips.forEach(Runnable::run);
        this.tooltips.clear();
    }

    protected void setAsActive(CosmeticInfo info) {
        UUID player = Minecraft.func_71410_x().field_71439_g.func_110124_au();
        boolean isWearing = this.backingDataStore.getActive(player).contains(info);
        if (isWearing) {
            this.backingDataStore.clearCosmetic(player, info.id);
            this.equipCallback.sync(info.slot, null);
        } else {
            this.backingDataStore.set(player, info.id);
            this.equipCallback.sync(info.slot, info.id);
        }
        this.setCosmetics(this.cosmetics);
    }

    protected void setAsFavourite(CosmeticInfo info) {
        UUID player = Minecraft.func_71410_x().field_71439_g.func_110124_au();
        if (this.backingDataStore.isFavourite(player, info.id)) {
            this.backingDataStore.unfavourite(player, info.id);
        } else {
            this.backingDataStore.favourite(player, info.id);
        }
        this.favouriteCallback.sync(info.slot, info.id, this.backingDataStore.isFavourite(player, info.id));
        this.btns.get((Object)info.id).buttonStateFavourite = this.backingDataStore.isFavourite(player, info.id);
    }

    protected int func_230952_d_() {
        return this.x + this.buttonCount * 38 + 10;
    }

    public int func_230949_c_() {
        return this.width;
    }

    protected boolean func_230971_aw__() {
        return true;
    }

    public static interface OnFavouriteCallback {
        public void sync(ResourceLocation var1, ResourceLocation var2, boolean var3);
    }

    public static interface OnEquipCallback {
        public void sync(ResourceLocation var1, ResourceLocation var2);
    }

    public static class Entry
    extends ExtendedList.AbstractListEntry<Entry> {
        List<Widget> buttons;

        public Entry(List<Widget> buttons) {
            this.buttons = buttons;
        }

        public void func_230432_a_(MatrixStack p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            this.buttons.forEach(p_238519_5_ -> {
                p_238519_5_.field_230691_m_ = p_230432_3_;
                p_238519_5_.func_230430_a_(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            });
        }
    }
}

