/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.data.impl;

import ca.lukegrahamlandry.cosmetology.data.DataStoreImpl;
import ca.lukegrahamlandry.cosmetology.data.api.CosmeticInfo;
import ca.lukegrahamlandry.cosmetology.data.api.DataStoreAvailable;
import ca.lukegrahamlandry.cosmetology.data.api.DataStoreUnlocked;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.util.ResourceLocation;

public class ModSupportCosmetics
extends DataStoreImpl {
    public static ModSupportCosmetics INSTANCE = new ModSupportCosmetics("mod_supporters");
    private Map<String, DataStoreAvailable> availableCosmetics = new HashMap<String, DataStoreAvailable>();
    private Map<String, DataStoreUnlocked> unlockedCosmetics = new HashMap<String, DataStoreUnlocked>();

    public ModSupportCosmetics(String id) {
        super(id);
    }

    public static void registerAvailable(String modid, DataStoreAvailable available) {
        ModSupportCosmetics.INSTANCE.availableCosmetics.put(modid, available);
    }

    public static void registerUnlocked(String modid, DataStoreUnlocked unlocked) {
        ModSupportCosmetics.INSTANCE.unlockedCosmetics.put(modid, unlocked);
    }

    @Override
    public Collection<CosmeticInfo> getAll() {
        ArrayList<CosmeticInfo> all = new ArrayList<CosmeticInfo>();
        this.availableCosmetics.forEach((modid, available) -> all.addAll(available.getAll()));
        return all;
    }

    @Override
    public CosmeticInfo getInfo(ResourceLocation cosmetic) {
        for (Map.Entry<String, DataStoreAvailable> entry : this.availableCosmetics.entrySet()) {
            CosmeticInfo info = entry.getValue().getInfo(cosmetic);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Override
    public Set<ResourceLocation> getSlots() {
        HashSet<ResourceLocation> all = new HashSet<ResourceLocation>();
        this.availableCosmetics.forEach((modid, available) -> all.addAll(available.getSlots()));
        return all;
    }

    @Override
    public boolean hasUnlocked(UUID player, ResourceLocation cosmetic) {
        for (Map.Entry<String, DataStoreUnlocked> entry : this.unlockedCosmetics.entrySet()) {
            if (!entry.getValue().hasUnlocked(player, cosmetic)) continue;
            return true;
        }
        return false;
    }
}

