/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.data;

import ca.lukegrahamlandry.cosmetology.data.PlayerCosmeticsCollection;
import ca.lukegrahamlandry.cosmetology.data.api.CosmeticInfo;
import ca.lukegrahamlandry.cosmetology.data.api.CosmeticSlots;
import ca.lukegrahamlandry.cosmetology.data.api.DataStore;
import ca.lukegrahamlandry.cosmetology.util.EncodeUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;

public class DataStoreImpl
implements DataStore {
    private final String id;
    protected Map<ResourceLocation, CosmeticInfo> cosmetics = new HashMap<ResourceLocation, CosmeticInfo>();
    protected Map<UUID, PlayerCosmeticsCollection> playerCosmetics = new HashMap<UUID, PlayerCosmeticsCollection>();
    public Runnable sync = () -> {};

    public DataStoreImpl(String id) {
        this.id = id;
    }

    @Override
    public String getStoreID() {
        return this.id;
    }

    @Override
    public Collection<CosmeticInfo> getAll() {
        return this.cosmetics.values();
    }

    @Override
    public void register(CosmeticInfo cosmetic) {
        if (cosmetic.isRegisterAllowed()) {
            this.cosmetics.put(cosmetic.id, cosmetic);
        }
    }

    @Override
    public CosmeticInfo getInfo(ResourceLocation cosmetic) {
        return this.cosmetics.get(cosmetic);
    }

    @Override
    public Set<ResourceLocation> getSlots() {
        return CosmeticSlots.getAll();
    }

    @Override
    public void set(UUID playerID, ResourceLocation slotKey, ResourceLocation cosmeticKey) {
        if (this.getOrCreateData(playerID).hasUnlocked(cosmeticKey) || cosmeticKey == null) {
            this.getOrCreateData(playerID).equip(slotKey, cosmeticKey);
        }
    }

    @Override
    public void clearCosmetic(UUID playerID, ResourceLocation cosmeticKey) {
        ArrayList<ResourceLocation> slotsToClear = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, ResourceLocation> data : this.getOrCreateData((UUID)playerID).equipped.entrySet()) {
            if (!data.getValue().equals((Object)cosmeticKey)) continue;
            slotsToClear.add(data.getKey());
        }
        for (ResourceLocation slot : slotsToClear) {
            this.clearSlot(playerID, slot);
        }
    }

    @Override
    public void clearSlot(UUID playerID, ResourceLocation slotKey) {
        this.getOrCreateData(playerID).equip(slotKey, null);
    }

    @Override
    public List<CosmeticInfo> getActive(UUID playerID) {
        return this.getOrCreateData((UUID)playerID).equipped.values().stream().map(this::getInfo).collect(Collectors.toList());
    }

    @Override
    public CosmeticInfo getInSlot(UUID playerID, ResourceLocation slotID) {
        return this.getInfo(this.getOrCreateData(playerID).getFromSlot(slotID));
    }

    @Override
    public void unequipAll(UUID player) {
        for (ResourceLocation slot : CosmeticSlots.getAll()) {
            this.clearSlot(player, slot);
        }
    }

    @Override
    public void unlock(UUID player, ResourceLocation cosmeticKey) {
        this.getOrCreateData(player).unlock(cosmeticKey);
    }

    @Override
    public void lock(UUID player, ResourceLocation cosmeticKey) {
        this.getOrCreateData(player).lock(cosmeticKey);
    }

    @Override
    public boolean hasUnlocked(UUID player, ResourceLocation cosmetic) {
        return this.getOrCreateData(player).hasUnlocked(cosmetic);
    }

    @Override
    public void lockAll(UUID player) {
        this.getOrCreateData(player).lockAll();
    }

    @Override
    public void favourite(UUID player, ResourceLocation cosmeticKey) {
        this.getOrCreateData(player).favourite(cosmeticKey);
    }

    @Override
    public void unfavourite(UUID player, ResourceLocation cosmeticKey) {
        this.getOrCreateData(player).unfavourite(cosmeticKey);
    }

    @Override
    public boolean isFavourite(UUID player, ResourceLocation cosmetic) {
        return this.getOrCreateData(player).isFavourite(cosmetic);
    }

    @Override
    public void unfavouriteAll(UUID player) {
        this.getOrCreateData(player).unfavouriteAll();
    }

    public PlayerCosmeticsCollection getOrCreateData(UUID playerID) {
        if (!this.playerCosmetics.containsKey(playerID)) {
            this.playerCosmetics.put(playerID, new PlayerCosmeticsCollection());
        }
        return this.playerCosmetics.get(playerID);
    }

    public String write() {
        JsonObject data = EncodeUtil.GSON.toJsonTree(this.playerCosmetics).getAsJsonObject();
        return data.toString();
    }

    public void read(String data) {
        JsonObject info = (JsonObject)EncodeUtil.GSON.fromJson(data, JsonObject.class);
        this.playerCosmetics.clear();
        for (Map.Entry entry : info.entrySet()) {
            this.playerCosmetics.put(UUID.fromString((String)entry.getKey()), (PlayerCosmeticsCollection)EncodeUtil.GSON.fromJson(((JsonElement)entry.getValue()).toString(), PlayerCosmeticsCollection.class));
        }
    }
}

