/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.client.screen.widget.btn;

import ca.lukegrahamlandry.cosmetology.client.geo.GeoCosmeticRender;
import ca.lukegrahamlandry.cosmetology.client.geo.NullItem;
import ca.lukegrahamlandry.cosmetology.client.screen.widget.Drawable;
import ca.lukegrahamlandry.cosmetology.client.screen.widget.btn.ImgButton;
import ca.lukegrahamlandry.cosmetology.data.api.CosmeticInfo;
import ca.lukegrahamlandry.cosmetology.data.api.CosmeticSlots;
import ca.lukegrahamlandry.cosmetology.data.type.GeoModelAdditionCosmetic;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class CosmeticButton
extends ImgButton {
    protected final CosmeticInfo cosmetic;
    private final Consumer<Runnable> tooltipAction;
    private final Button.IPressable rightClickCallback;
    private Drawable favouriteStar;
    public boolean buttonStateActive = false;
    public boolean buttonStateFavourite = false;
    private static ItemStack AN_ITEM_STACK = new ItemStack((IItemProvider)new NullItem((IArmorMaterial)ArmorMaterial.CHAIN, EquipmentSlotType.CHEST, new Item.Properties()));

    public CosmeticButton(CosmeticInfo cosmetic, int x, int y, int width, int height, Button.IPressable leftClickCallback, Button.IPressable rightClickCallback, Consumer<Runnable> tooltipAction, Drawable texture, Drawable hoveredTexture, Drawable activeTexture, Drawable favouriteStar) {
        super(x, y, width, height, leftClickCallback, CosmeticButton::tooltip, texture, hoveredTexture, activeTexture);
        this.cosmetic = cosmetic;
        this.tooltipAction = tooltipAction;
        this.favouriteStar = favouriteStar;
        this.rightClickCallback = rightClickCallback;
    }

    public boolean func_231044_a_(double x, double y, int button) {
        if (button == 1 && this.func_230992_c_(x, y)) {
            this.onRightclick();
        }
        return super.func_231044_a_(x, y, button);
    }

    private void onRightclick() {
        this.buttonStateFavourite = !this.buttonStateFavourite;
        this.rightClickCallback.onPress((Button)this);
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float p_230430_4_) {
        super.func_230430_a_(stack, mouseX, mouseY, p_230430_4_);
        if (this.buttonStateFavourite && this.field_230694_p_) {
            this.favouriteStar.blit(stack, this.field_230690_l_ + 30, this.field_230691_m_ + 3);
        }
        this.renderCosmetic();
    }

    public void renderCosmetic() {
        this.cosmetic.guiButtonRender(this.field_230690_l_ + this.field_230688_j_ / 2, this.field_230691_m_ + this.field_230689_k_ / 2, this.field_230688_j_, this.field_230689_k_, this.hasGlint(), false);
    }

    public static void transform(MatrixStack stack, CosmeticInfo cosmetic) {
        float slotYShift = 0.0f;
        float scale = 1.0f;
        if (cosmetic.slot.equals((Object)CosmeticSlots.HEAD)) {
            slotYShift = -10.0f;
            scale = 0.75f;
        } else if (cosmetic.slot.equals((Object)CosmeticSlots.CHEST)) {
            slotYShift = 10.0f;
            scale = 0.75f;
        } else if (cosmetic.slot.equals((Object)CosmeticSlots.LEGS)) {
            slotYShift = 30.0f;
        } else if (cosmetic.slot.equals((Object)CosmeticSlots.FEET)) {
            slotYShift = 40.0f;
        }
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(30.0f));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        stack.func_227861_a_(0.0, (double)slotYShift, 0.0);
        stack.func_227862_a_(scale, scale, 1.0f);
    }

    public static void renderGeoModelCosmetic(GeoModelAdditionCosmetic cosmetic, int centerX, int centerY, int width, int height, boolean glint, boolean selected) {
        int scale = 30;
        float lookAtX = 0.0f;
        float lookAtY = 0.0f;
        float f = (float)Math.atan(lookAtX / 40.0f);
        float f1 = (float)Math.atan(lookAtY / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)centerX, (float)centerY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        CosmeticButton.transform(matrixstack, cosmetic);
        matrixstack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> {
            float p_229084_1_ = 0.0f;
            float p_229084_9_ = 1.0f;
            float p_229084_2_ = 0.0f;
            float p_229084_4_ = 0.0f;
            float p_229084_6_ = 0.0f;
            float p_229084_8_ = 0.0f;
            int p_229084_12_ = 0xF000F0;
            Vector3d vector3d = Vector3d.field_186680_a;
            double d2 = (double)p_229084_2_ + vector3d.func_82615_a();
            double d3 = (double)p_229084_4_ + vector3d.func_82617_b();
            double d0 = (double)p_229084_6_ + vector3d.func_82616_c();
            matrixstack.func_227860_a_();
            matrixstack.func_227861_a_(d2, d3, d0);
            GeoCosmeticRender geoRenderer = new GeoCosmeticRender(cosmetic);
            geoRenderer.setCurrentItem((LivingEntity)Minecraft.func_71410_x().field_71439_g, AN_ITEM_STACK, EquipmentSlotType.CHEST);
            geoRenderer.filterBones();
            IVertexBuilder vertex = ItemRenderer.func_239386_a_((IRenderTypeBuffer)irendertypebuffer$impl, (RenderType)RenderType.func_239263_a_((ResourceLocation)cosmetic.getTexture()), (boolean)false, (boolean)false);
            geoRenderer.render(0.0f, matrixstack, vertex, p_229084_12_);
            matrixstack.func_227861_a_(-vector3d.func_82615_a(), -vector3d.func_82617_b(), -vector3d.func_82616_c());
            matrixstack.func_227865_b_();
        });
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        RenderSystem.popMatrix();
    }

    private static void tooltip(Button button, MatrixStack matrix, int xM, int yM) {
        ((CosmeticButton)button).tooltipAction.accept(() -> GuiUtils.drawHoveringText((MatrixStack)matrix, Arrays.asList(((CosmeticButton)button).getTitle(), ((CosmeticButton)button).getDescription()), (int)xM, (int)yM, (int)400, (int)200, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p));
    }

    public boolean hasGlint() {
        return false;
    }

    public TextComponent getTitle() {
        return this.cosmetic.getDisplayTitle();
    }

    public TextComponent getDescription() {
        return this.cosmetic.getDisplayDescription();
    }
}

