/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.client.screen.widget.btn;

import ca.lukegrahamlandry.cosmetology.client.screen.widget.Drawable;
import ca.lukegrahamlandry.cosmetology.client.screen.widget.btn.ImgButton;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ButtonRowGroup
extends Widget {
    private List<ImgButton> tabButtons = new ArrayList<ImgButton>();
    public ImgButton leftButton;
    public ImgButton rightButton;
    private int tabOffset = 0;
    public int currentTab = 0;
    private int btnWidth;
    private int btnCount;
    private final Consumer<Button> buttonAdder;
    private final List<Drawable> buttonIcons;
    private Consumer<Integer> onSelect;
    private int btnHeight;
    public Drawable texture;
    public Drawable hoveredTexture;
    public Drawable activeTexture;
    public Drawable leftIcon;
    public Drawable rightIcon;
    int offsetWithLastSelected = 0;

    public ButtonRowGroup(int x, int y, int btnWidth, int btnHeight, int btnCount, Consumer<Button> buttonAdder, List<Drawable> buttonIcons, Consumer<Integer> onSelect) {
        super(x, y, 1, 1, (ITextComponent)new StringTextComponent(""));
        this.btnWidth = btnWidth;
        this.btnHeight = btnHeight;
        this.btnCount = btnCount;
        this.buttonAdder = buttonAdder;
        this.buttonIcons = buttonIcons;
        this.onSelect = onSelect;
    }

    public void init() {
        if (this.leftButton == null) {
            this.leftButton = new ImgButton(this.field_230690_l_ - this.leftIcon.width, this.field_230691_m_, this.leftIcon.width, this.leftIcon.height, btn -> this.shift(-1), (a, b, c, d) -> {}, this.leftIcon, this.leftIcon, this.leftIcon);
            this.rightButton = new ImgButton(this.field_230690_l_ + this.btnCount * this.btnWidth, this.field_230691_m_, this.leftIcon.width, this.leftIcon.height, btn -> this.shift(1), (a, b, c, d) -> {}, this.rightIcon, this.rightIcon, this.rightIcon);
            this.buttonAdder.accept(this.leftButton);
            this.buttonAdder.accept(this.rightButton);
        }
        this.tabButtons.forEach(b -> {
            b.field_230694_p_ = false;
            b.field_230693_o_ = false;
        });
        this.tabButtons.clear();
        int xOffset = this.field_230690_l_;
        for (int i = 0; i < this.btnCount; ++i) {
            int finalI = i;
            if (this.buttonIcons.size() <= i + this.tabOffset) break;
            Drawable icon = this.buttonIcons.get(i + this.tabOffset);
            ImgButton btn2 = new ImgButton(xOffset, this.field_230691_m_, this.btnWidth, this.btnHeight, b -> this.buttonPress(finalI + this.tabOffset), (a, b, c, d) -> {}, new Drawable.Multi(this.texture, icon), new Drawable.Multi(this.hoveredTexture, icon), new Drawable.Multi(this.activeTexture, icon));
            btn2.buttonStateActive = this.currentTab == i + this.tabOffset;
            this.tabButtons.add(btn2);
            this.buttonAdder.accept(btn2);
            xOffset += this.btnWidth;
        }
    }

    private void shift(int dir) {
        this.tabOffset += dir * this.btnCount;
        this.tabOffset = Math.max(this.tabOffset, 0);
        this.tabOffset = Math.min(this.tabOffset, this.buttonIcons.size());
        this.init();
    }

    private void buttonPress(int index) {
        this.onSelect.accept(index);
        if (this.tabOffset == this.offsetWithLastSelected) {
            this.tabButtons.get((int)(this.currentTab % this.btnCount)).buttonStateActive = false;
        }
        this.currentTab = index;
        this.tabButtons.get((int)(this.currentTab % this.btnCount)).buttonStateActive = true;
        this.offsetWithLastSelected = this.tabOffset;
    }

    public static class TabBtnData {
        Drawable icon;
        private ResourceLocation data;

        public TabBtnData(Drawable icon, ResourceLocation data) {
            this.icon = icon;
            this.data = data;
        }
    }
}

