/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.cosmetology.client.geo;

import ca.lukegrahamlandry.cosmetology.CosmetologyApi;
import ca.lukegrahamlandry.cosmetology.client.geo.GeoCosmeticRender;
import ca.lukegrahamlandry.cosmetology.client.geo.NullItem;
import ca.lukegrahamlandry.cosmetology.data.api.CosmeticInfo;
import ca.lukegrahamlandry.cosmetology.data.api.DataStore;
import ca.lukegrahamlandry.cosmetology.data.type.GeoModelAdditionCosmetic;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class GeoCosmeticLayer
extends BipedArmorLayer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>, BipedModel<AbstractClientPlayerEntity>> {
    PlayerRenderer field_215335_a;
    private static final Map<CosmeticInfo, GeoCosmeticRender> modelCache = new HashMap<CosmeticInfo, GeoCosmeticRender>();
    private static ItemStack AN_ITEM_STACK = new ItemStack((IItemProvider)new NullItem((IArmorMaterial)ArmorMaterial.CHAIN, EquipmentSlotType.CHEST, new Item.Properties()));

    public GeoCosmeticLayer(PlayerRenderer renderer) {
        super((IEntityRenderer)renderer, null, null);
        this.field_215335_a = renderer;
    }

    public void render(MatrixStack matrix, IRenderTypeBuffer buffer, int light, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        for (DataStore source : CosmetologyApi.getSources()) {
            for (CosmeticInfo cosmetic : source.getActive(player.func_110124_au())) {
                if (!(cosmetic instanceof GeoModelAdditionCosmetic)) continue;
                this.renderCosmetic(matrix, buffer, player, light, (GeoModelAdditionCosmetic)cosmetic, partialTicks);
            }
        }
    }

    private void renderCosmetic(MatrixStack matrix, IRenderTypeBuffer buffer, AbstractClientPlayerEntity player, int light, GeoModelAdditionCosmetic cosmetic, float partialTicks) {
        if (!modelCache.containsKey(cosmetic)) {
            modelCache.put(cosmetic, new GeoCosmeticRender(cosmetic));
        }
        GeoCosmeticRender geoRenderer = modelCache.get(cosmetic);
        GeoCosmeticLayer.copyRotations((BipedModel)this.field_215335_a.func_217764_d(), geoRenderer);
        geoRenderer.applyEntityStats((BipedModel)this.field_215335_a.func_217764_d());
        geoRenderer.setCurrentItem((LivingEntity)player, AN_ITEM_STACK, EquipmentSlotType.CHEST);
        geoRenderer.filterBones();
        IVertexBuilder vertex = ItemRenderer.func_239386_a_((IRenderTypeBuffer)buffer, (RenderType)RenderType.func_239263_a_((ResourceLocation)cosmetic.getTexture()), (boolean)false, (boolean)false);
        geoRenderer.render(partialTicks, matrix, vertex, light);
    }

    private static void copyRotations(BipedModel<?> from, BipedModel<?> to) {
        GeoCosmeticLayer.copyRotations(from.field_78116_c, to.field_78116_c);
        GeoCosmeticLayer.copyRotations(from.field_178720_f, to.field_178720_f);
        GeoCosmeticLayer.copyRotations(from.field_78115_e, to.field_78115_e);
        GeoCosmeticLayer.copyRotations(from.field_178724_i, to.field_178724_i);
        GeoCosmeticLayer.copyRotations(from.field_178723_h, to.field_178723_h);
        GeoCosmeticLayer.copyRotations(from.field_178721_j, to.field_178721_j);
        GeoCosmeticLayer.copyRotations(from.field_178722_k, to.field_178722_k);
    }

    private static void copyRotations(ModelRenderer from, ModelRenderer to) {
        to.field_78795_f = from.field_78795_f;
        to.field_78796_g = from.field_78796_g;
        to.field_78808_h = from.field_78808_h;
        to.field_78800_c = from.field_78800_c;
        to.field_78797_d = from.field_78797_d;
        to.field_78798_e = from.field_78798_e;
    }
}

